﻿Imports BaiqiSoft.HtmlEditorControl


Public Class frmMain
    Public Sub New()
        InitializeComponent()
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        HtmlEditor1.LicenseKey = "Enter you license key here"
        HtmlEditor1.ToolbarButtons.SaveAs.Visible = False
        'Load German dictionaries
        'HtmlEditor1.SpellingOptions.DictionaryFile = New DictionaryFile("Dictionaries\de_DE_frami.aff", "Dictionaries\de_DE_frami.dic")
        HtmlEditor1.Focus()
        frmMain_Resize(Me, EventArgs.Empty)
    End Sub

    Private Sub HtmlEditor1_SpellingOptionsButtonClick(sender As Object, e As System.ComponentModel.CancelEventArgs) Handles HtmlEditor1.SpellingOptionsButtonClick
        'You can show your own Spelling Options window by set the Cancel property to True.
        'e.Cancel = True
    End Sub

    Private Sub frmMain_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        HtmlEditor1.Location = New Point(0, MenuStrip1.Height)
        HtmlEditor1.Size = New Size(ClientSize.Width, ClientSize.Height - MenuStrip1.Height)
    End Sub

    Private Sub HtmlEditor1_UpdateUI(ByVal sender As Object, ByVal e As System.EventArgs) Handles HtmlEditor1.UpdateUI
        'Edit menu
        btnUndo.Enabled = HtmlEditor1.CanUndo
        btnRedo.Enabled = HtmlEditor1.CanRedo
        btnCut.Enabled = HtmlEditor1.Selection.CanCut
        btnCopy.Enabled = HtmlEditor1.Selection.CanCopy
        btnPaste.Enabled = HtmlEditor1.Selection.CanPaste
        btnDelete.Enabled = HtmlEditor1.Selection.CanDelete
        'Insert menu
        If HtmlEditor1.EditorMode = EditorMode.Design Then
            btnPicture.Enabled = True
            btnHorizontalLine.Enabled = True
            btnSymbol.Enabled = True
            btnHyperlink.Enabled = True
        Else
            btnPicture.Enabled = False
            btnHorizontalLine.Enabled = False
            btnSymbol.Enabled = False
            btnHyperlink.Enabled = False
        End If
    End Sub

    Private Sub HtmlEditor1_ToolbarButtonClick(ByVal sender As Object, ByVal e As ToolbarButtonEventArgs) Handles HtmlEditor1.ToolbarButtonClick
        'Select Case e.Button
        '    Case ToolbarButton.NewFile
        '        'Set Handled to true to cancel the default processing.
        '        e.Handled = True
        '        'Before creating a new page, we may have to do something.
        '        If MsgBox("So you want to create a new page?", MsgBoxStyle.YesNo, "Info") <> MsgBoxResult.Yes Then
        '            Return
        '        End If
        '        'Creating a new page by ourselves.
        '        HtmlEditor1.InvokeToolbarButtonClick(e)
        '    Case ToolbarButton.OpenFile
        '        'Set Handled to true to cancel the default processing.
        '        e.Handled = True
        '        'Opening a document by ourselves.
        '        HtmlEditor1.InvokeToolbarButtonClick(e)
        '        'After finished opening the document, we may have to do something.
        '        MsgBox("Finished opening the document.", MsgBoxStyle.OkOnly, "Info")
        'End Select
    End Sub

#Region "Menu Items"
    Private Sub btnNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNew.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.NewFile)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.OpenFile)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSave.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.SaveFile)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnSaveAs_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveAs.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.SaveAs)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnPageSetup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPageSetup.Click
        HtmlEditor1.ShowPageSetupDialog()
    End Sub

    Private Sub btnPrintPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrintPreview.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.PrintPreview)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Print)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        Me.Close()
    End Sub

    Private Sub btnUndo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUndo.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Undo)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnRedo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRedo.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Redo)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnCut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCut.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Cut)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnCopy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCopy.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Copy)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnPaste_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPaste.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.Paste)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        HtmlEditor1.Selection.Delete()
    End Sub

    Private Sub btnSelectAll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectAll.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.SelectAll)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnPicture_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPicture.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.InsertPicture)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnHorizontalLine_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHorizontalLine.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.InsertHorizontalLine)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnSymbol_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSymbol.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.InsertSymbol)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnHyperlink_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHyperlink.Click
        Dim button As New ToolbarButtonEventArgs(ToolbarButton.InsertHyperlink)
        HtmlEditor1.InvokeToolbarButtonClick(button)
    End Sub

    Private Sub btnHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHelp.Click
        HtmlEditor.OpenWebLink("http://www.mysofttool.com/help/htmleditor")
    End Sub

    Private Sub btnCheckUpdates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCheckUpdates.Click
        HtmlEditor.OpenWebLink("http://www.mysofttool.com/net-winforms-html-editor-control")
    End Sub

    Private Sub btnPurchase_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPurchase.Click
        HtmlEditor.OpenWebLink("http://www.mysofttool.com/purchase")
    End Sub

    Private Sub btnAbout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAbout.Click
        HtmlEditor1.AboutBox()
    End Sub

    Private Sub btnStyleSheetLinks_Click(sender As System.Object, e As System.EventArgs) Handles btnStyleSheetLinks.Click
        frmLinkStyleSheet.ShowDialog()
    End Sub
#End Region
End Class
